/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.serialize;

import com.google.errorprone.annotations.ForOverride;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.util.CheckedConsumer;

public abstract class AbstractListChildSerializer<T>
implements TypeSerializer.Annotated<T> {
    protected AbstractListChildSerializer() {
    }

    @Override
    public final T deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        AnnotatedType entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        if (node.isList()) {
            List<? extends ConfigurationNode> values = node.childrenList();
            T ret = this.createNew(values.size(), entryType);
            for (int i = 0; i < values.size(); ++i) {
                try {
                    this.deserializeSingle(i, ret, entrySerial.deserialize(entryType, values.get(i)));
                    continue;
                }
                catch (SerializationException ex) {
                    ex.initPath(values.get(i)::path);
                    throw ex;
                }
            }
            return ret;
        }
        @Nullable Object unwrappedVal = node.raw();
        if (unwrappedVal != null) {
            T ret = this.createNew(1, entryType);
            this.deserializeSingle(0, ret, entrySerial.deserialize(entryType, node));
            return ret;
        }
        return this.createNew(0, entryType);
    }

    @Override
    public final void serialize(AnnotatedType type, @Nullable T obj, ConfigurationNode node) throws SerializationException {
        AnnotatedType entryType = this.elementType(type);
        @Nullable TypeSerializer<?> entrySerial = node.options().serializers().get(entryType);
        if (entrySerial == null) {
            throw new SerializationException(node, entryType, "No applicable type serializer for type");
        }
        node.raw(Collections.emptyList());
        if (obj != null) {
            this.forEachElement(obj, el -> {
                ConfigurationNode child = node.appendListNode();
                try {
                    entrySerial.serialize(entryType, el, child);
                }
                catch (SerializationException ex) {
                    ex.initPath(child::path);
                    throw ex;
                }
            });
        }
    }

    @Override
    public @Nullable T emptyValue(AnnotatedType specificType, ConfigurationOptions options) {
        try {
            return this.createNew(0, this.elementType(specificType));
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    @ForOverride
    protected AnnotatedType elementType(AnnotatedType containerType) throws SerializationException {
        return GenericTypeReflector.annotate((Type)this.elementType(containerType.getType()));
    }

    @Deprecated
    protected Type elementType(Type containerType) throws SerializationException {
        throw new IllegalStateException("AbstractListChildSerializer implementations should override elementType(AnnotatedType)");
    }

    @ForOverride
    protected T createNew(int length, AnnotatedType elementType) throws SerializationException {
        return this.createNew(length, elementType.getType());
    }

    @Deprecated
    @ForOverride
    protected T createNew(int length, Type elementType) throws SerializationException {
        throw new IllegalStateException("AbstractListChildSerializer implementations should override createNew(int, AnnotatedType)");
    }

    @ForOverride
    protected abstract void forEachElement(T var1, CheckedConsumer<Object, SerializationException> var2) throws SerializationException;

    @ForOverride
    protected abstract void deserializeSingle(int var1, T var2, @Nullable Object var3) throws SerializationException;
}

