/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter.proxygenerator;

import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class ProxyGenerator {
    private ProxyGenerator() {
    }

    public static byte[] generateProxy(Class<?> proxyImplementation, String generatedClassName) {
        Set<Class<?>> parents = ProxyGenerator.findParents(proxyImplementation);
        return ProxyGenerator.generateProxy(ProxyGenerator.classReader(proxyImplementation.getName()), generatedClassName, (ClassReader[])parents.stream().map(p -> ProxyGenerator.classReader(p.getName())).toArray(ClassReader[]::new));
    }

    public static byte[] generateProxy(ClassReader proxyImplementation, String generatedClassName, ClassReader ... parents) {
        DiscoverMethodsVisitor scanImpl = new DiscoverMethodsVisitor(589824, null);
        proxyImplementation.accept((ClassVisitor)scanImpl, 1);
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>(scanImpl.methods);
        String proxy = scanImpl.name;
        for (ClassReader parent : parents) {
            DiscoverMethodsVisitor scanInterface = new DiscoverMethodsVisitor(589824, null);
            parent.accept((ClassVisitor)scanInterface, 1);
            methods.addAll(scanInterface.methods);
        }
        ClassWriter classWriter = new ClassWriter(0);
        classWriter.visit(61, 49, generatedClassName, null, "java/lang/Object", null);
        ProxyGenerator.instanceField(classWriter, proxy);
        ProxyGenerator.constructor(classWriter);
        ProxyGenerator.initMethod(classWriter, generatedClassName, proxy);
        for (MethodInfo method : methods) {
            ProxyGenerator.proxyMethod(classWriter, generatedClassName, proxy, method);
        }
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private static void instanceField(ClassWriter classWriter, String proxy) {
        FieldVisitor fieldVisitor = classWriter.visitField(10, "INSTANCE", "L" + proxy + ";", null, null);
        fieldVisitor.visitEnd();
    }

    private static void constructor(ClassWriter classWriter) {
        MethodVisitor visitor = classWriter.visitMethod(2, "<init>", "()V", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        visitor.visitTypeInsn(187, "java/lang/IllegalStateException");
        visitor.visitInsn(89);
        visitor.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "()V", false);
        visitor.visitInsn(191);
        visitor.visitMaxs(2, 1);
        visitor.visitEnd();
    }

    private static void initMethod(ClassWriter classWriter, String generatedClassName, String proxy) {
        MethodVisitor visitor = classWriter.visitMethod(9, "init", "(L" + proxy + ";)V", null, null);
        visitor.visitCode();
        visitor.visitVarInsn(25, 0);
        visitor.visitFieldInsn(179, generatedClassName, "INSTANCE", "L" + proxy + ";");
        visitor.visitInsn(177);
        visitor.visitMaxs(1, 1);
        visitor.visitEnd();
    }

    private static void proxyMethod(ClassWriter classWriter, String generatedClassName, String proxy, MethodInfo method) {
        MethodVisitor visitor = classWriter.visitMethod(9, method.name, method.descriptor, method.signature, method.exceptions);
        visitor.visitCode();
        visitor.visitFieldInsn(178, generatedClassName, "INSTANCE", "L" + proxy + ";");
        int stackSize = 1;
        Type methodType = Type.getType((String)method.descriptor);
        int locals = 0;
        for (Type argumentType : methodType.getArgumentTypes()) {
            visitor.visitVarInsn(argumentType.getOpcode(21), locals);
            locals += argumentType.getSize();
        }
        stackSize += locals;
        visitor.visitMethodInsn(182, proxy, method.name, method.descriptor, false);
        visitor.visitInsn(methodType.getReturnType().getOpcode(172));
        visitor.visitMaxs(stackSize += methodType.getReturnType().getSize(), locals);
        visitor.visitEnd();
    }

    private static Set<Class<?>> findParents(Class<?> clazz) {
        HashSet ret = new HashSet();
        ProxyGenerator.findParents(ret, clazz);
        return ret;
    }

    private static void findParents(Set<Class<?>> ret, Class<?> clazz) {
        @Nullable Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            ret.add(superClass);
            ProxyGenerator.findParents(ret, superClass);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            ret.add(iface);
            ProxyGenerator.findParents(ret, iface);
        }
    }

    private static ClassReader classReader(String className) {
        ClassReader classReader;
        block8: {
            @Nullable InputStream is = ProxyGenerator.class.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
            try {
                Objects.requireNonNull(is, () -> "Class '" + className + "'");
                classReader = new ClassReader(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Failed to read class '" + className + "'", ex);
                }
            }
            is.close();
        }
        return classReader;
    }

    private static final class DiscoverMethodsVisitor
    extends ClassVisitor {
        private final List<MethodInfo> methods = new ArrayList<MethodInfo>();
        private @MonotonicNonNull String name;

        DiscoverMethodsVisitor(int api, @Nullable ClassVisitor visitor) {
            super(api, visitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (!Modifier.isStatic(access) && Modifier.isPublic(access) && !name.equals("<init>")) {
                this.methods.add(new MethodInfo(name, descriptor, signature, exceptions));
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }

    private record MethodInfo(String name, String descriptor, @Nullable String signature, String @Nullable [] exceptions) {
        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            return this.name.equals(that.name) && this.descriptor.equals(that.descriptor) && Objects.equals(this.signature, that.signature) && Arrays.equals(this.exceptions, that.exceptions);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.name, this.descriptor, this.signature);
            result = 31 * result + Arrays.hashCode(this.exceptions);
            return result;
        }
    }
}

