/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.weather;

import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.weather.WeatherEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ThunderChangeEvent
extends WeatherEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean canceled;
    private final boolean to;
    private final Cause cause;

    @ApiStatus.Internal
    public ThunderChangeEvent(@NotNull World world, boolean to, @NotNull Cause cause) {
        super(world);
        this.to = to;
        this.cause = cause;
    }

    @Deprecated(forRemoval=true)
    public ThunderChangeEvent(@NotNull World world, boolean to) {
        super(world);
        this.to = to;
        this.cause = Cause.UNKNOWN;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.canceled = cancel;
    }

    public boolean toThunderState() {
        return this.to;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public Cause getCause() {
        return this.cause;
    }

    public static enum Cause {
        COMMAND,
        NATURAL,
        SLEEP,
        PLUGIN,
        UNKNOWN;

    }
}

