/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.damage;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface DamageSource {
    @NotNull
    public DamageType getDamageType();

    @Nullable
    public Entity getCausingEntity();

    @Nullable
    public Entity getDirectEntity();

    @Nullable
    public Location getDamageLocation();

    @Nullable
    public Location getSourceLocation();

    public boolean isIndirect();

    public float getFoodExhaustion();

    public boolean scalesWithDifficulty();

    @NotNull
    public static Builder builder(@NotNull DamageType damageType) {
        return Bukkit.getUnsafe().createDamageSourceBuilder(damageType);
    }

    public static interface Builder {
        @NotNull
        public Builder withCausingEntity(@NotNull Entity var1);

        @NotNull
        public Builder withDirectEntity(@NotNull Entity var1);

        @NotNull
        public Builder withDamageLocation(@NotNull Location var1);

        @NotNull
        public DamageSource build();
    }
}

