/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.item.ItemComponentTypesBridge;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface ItemLore {
    @Contract(value="_ -> new", pure=true)
    public static ItemLore lore(List<? extends ComponentLike> lines) {
        return (ItemLore)ItemLore.lore().lines(lines).build();
    }

    @Contract(value="-> new", pure=true)
    public static Builder lore() {
        return ItemComponentTypesBridge.bridge().lore();
    }

    @Contract(pure=true)
    public @Unmodifiable List<Component> lines();

    @Contract(pure=true)
    public @Unmodifiable List<Component> styledLines();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends DataComponentBuilder<ItemLore> {
        @Contract(value="_ -> this", mutates="this")
        public Builder lines(List<? extends ComponentLike> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addLine(ComponentLike var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder addLines(List<? extends ComponentLike> var1);
    }
}

