/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Obsolete(since="1.21.4")
public class PlayerArmorChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final SlotType slotType;
    private final ItemStack oldItem;
    private final ItemStack newItem;

    @ApiStatus.Internal
    public PlayerArmorChangeEvent(Player player, SlotType slotType, ItemStack oldItem, ItemStack newItem) {
        super(player);
        this.slotType = slotType;
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    @Deprecated(since="1.21.4")
    public SlotType getSlotType() {
        return this.slotType;
    }

    public EquipmentSlot getSlot() {
        return switch (this.slotType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EquipmentSlot.HEAD;
            case 1 -> EquipmentSlot.CHEST;
            case 2 -> EquipmentSlot.LEGS;
            case 3 -> EquipmentSlot.FEET;
        };
    }

    public ItemStack getOldItem() {
        return this.oldItem;
    }

    public ItemStack getNewItem() {
        return this.newItem;
    }

    @Override
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @Deprecated(since="1.21.4")
    public static enum SlotType {
        HEAD(Material.NETHERITE_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET, Material.CARVED_PUMPKIN, Material.PLAYER_HEAD, Material.SKELETON_SKULL, Material.ZOMBIE_HEAD, Material.CREEPER_HEAD, Material.WITHER_SKELETON_SKULL, Material.TURTLE_HELMET, Material.DRAGON_HEAD, Material.PIGLIN_HEAD),
        CHEST(Material.NETHERITE_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE, Material.ELYTRA),
        LEGS(Material.NETHERITE_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS),
        FEET(Material.NETHERITE_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS);

        private final Set<Material> types;

        private SlotType(Material ... types) {
            this.types = Set.of(types);
        }

        public Set<Material> getTypes() {
            return this.types;
        }

        public static @Nullable SlotType getByMaterial(Material material) {
            for (SlotType slotType : SlotType.values()) {
                if (!slotType.getTypes().contains(material)) continue;
                return slotType;
            }
            return null;
        }

        public static boolean isEquipable(Material material) {
            return SlotType.getByMaterial(material) != null;
        }
    }
}

