/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.ansi;

import net.kyori.ansi.ColorLevel;
import org.fusesource.jansi.AnsiColors;
import org.fusesource.jansi.AnsiConsole;

final class JAnsiColorLevel {
    private static final Throwable UNAVAILABILITY_CAUSE;

    private JAnsiColorLevel() {
    }

    static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    static ColorLevel computeFromJAnsi() {
        AnsiColors colors = AnsiConsole.out().getColors();
        if (colors == null) {
            return ColorLevel.NONE;
        }
        switch (colors) {
            case Colors16: {
                return ColorLevel.INDEXED_16;
            }
            case Colors256: {
                return ColorLevel.INDEXED_256;
            }
            case TrueColor: {
                return ColorLevel.TRUE_COLOR;
            }
        }
        return ColorLevel.NONE;
    }

    static {
        ClassNotFoundException cause = null;
        try {
            Class.forName("org.fusesource.jansi.AnsiConsole");
        }
        catch (ClassNotFoundException classNotFoundException) {
            cause = classNotFoundException;
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

