/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.builder.RuleFactory;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;

@FunctionalInterface
public interface RewriteRule {
    public static final RewriteRule EMPTY = (api, parent, context) -> new ClassVisitor(api, parent){};

    @SafeVarargs
    public static RewriteRule forOwnerClass(Class<?> owner, Consumer<? super RuleFactory> firstFactoryConsumer, Consumer<? super RuleFactory> ... factoryConsumers) {
        return RewriteRule.forOwnerClasses(Collections.singleton(owner), firstFactoryConsumer, factoryConsumers);
    }

    @SafeVarargs
    public static RewriteRule forOwnerClasses(Set<Class<?>> owners, Consumer<? super RuleFactory> firstFactoryConsumer, Consumer<? super RuleFactory> ... factoryConsumers) {
        return RewriteRule.forOwners(owners.stream().map(c -> c.describeConstable().orElseThrow()).collect(Collectors.toUnmodifiableSet()), firstFactoryConsumer, factoryConsumers);
    }

    @SafeVarargs
    public static RewriteRule forOwner(ClassDesc owner, Consumer<? super RuleFactory> firstFactoryConsumer, Consumer<? super RuleFactory> ... factoryConsumers) {
        return RewriteRule.forOwners(Collections.singleton(owner), firstFactoryConsumer, factoryConsumers);
    }

    @SafeVarargs
    public static RewriteRule forOwners(Set<ClassDesc> owners, Consumer<? super RuleFactory> firstFactoryConsumer, Consumer<? super RuleFactory> ... factoryConsumers) {
        RuleFactory factory = RuleFactory.create(owners);
        firstFactoryConsumer.accept(factory);
        for (Consumer<? super RuleFactory> factoryConsumer : factoryConsumers) {
            factoryConsumer.accept(factory);
        }
        return factory.build();
    }

    public static RewriteRule chain(RewriteRule ... rules) {
        return RewriteRule.chain(Arrays.asList(rules));
    }

    public static RewriteRule chain(Collection<? extends RewriteRule> rules) {
        return new Chain(List.copyOf(rules));
    }

    public static ChainBuilder chain() {
        return new ChainBuilder();
    }

    public ClassVisitor createVisitor(int var1, ClassVisitor var2, ClassProcessingContext var3);

    public record Chain(List<RewriteRule> rules) implements RewriteRule
    {
        public Chain(List<RewriteRule> rules) {
            this.rules = List.copyOf(rules);
        }

        @Override
        public ClassVisitor createVisitor(int api, ClassVisitor parent, ClassProcessingContext context) {
            ClassVisitor visitor = parent;
            for (RewriteRule rule : this.rules) {
                visitor = rule.createVisitor(api, visitor, context);
            }
            return visitor;
        }
    }

    public static final class ChainBuilder {
        private final List<RewriteRule> rules = new ArrayList<RewriteRule>();

        private ChainBuilder() {
        }

        public ChainBuilder then(RewriteRule rule) {
            this.rules.add(rule);
            return this;
        }

        public ChainBuilder then(Collection<? extends RewriteRule> rules) {
            this.rules.addAll(rules);
            return this;
        }

        public ChainBuilder then(RewriteRule ... rules) {
            return this.then(Arrays.asList(rules));
        }

        public RewriteRule build() {
            return new Chain(this.rules);
        }
    }

    public static interface Delegate
    extends RewriteRule {
        public RewriteRule delegate();

        @Override
        default public ClassVisitor createVisitor(int api, ClassVisitor parent, ClassProcessingContext context) {
            return this.delegate().createVisitor(api, parent, context);
        }
    }

    @FunctionalInterface
    public static interface GeneratorAdapterFactory {
        public GeneratorAdapter create(int var1, String var2, String var3);
    }
}

