/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm;

import io.papermc.asm.ClassInfoProvider;
import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.RewriteRuleVisitorFactory;
import io.papermc.asm.rules.RewriteRule;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.ClassVisitor;

public abstract class AbstractRewriteRuleVisitorFactory
implements RewriteRuleVisitorFactory {
    private final int api;
    private volatile @MonotonicNonNull RewriteRule rule;
    private final ClassInfoProvider classInfoProvider;

    protected AbstractRewriteRuleVisitorFactory(int api, ClassInfoProvider classInfoProvider) {
        this.api = api;
        this.classInfoProvider = classInfoProvider;
    }

    protected abstract RewriteRule createRule();

    @Override
    public ClassVisitor createVisitor(ClassVisitor parent) {
        MutableProcessingContext context = new MutableProcessingContext();
        ClassVisitor ruleVisitor = this.rule().createVisitor(this.api, parent, context);
        return new ContextFillerVisitor(this.api, ruleVisitor, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final RewriteRule rule() {
        @Nullable RewriteRule rule = this.rule;
        if (rule != null) {
            return rule;
        }
        AbstractRewriteRuleVisitorFactory abstractRewriteRuleVisitorFactory = this;
        synchronized (abstractRewriteRuleVisitorFactory) {
            rule = this.rule;
            if (rule == null) {
                this.rule = rule = this.createRule();
            }
        }
        return rule;
    }

    private final class MutableProcessingContext
    implements ClassProcessingContext {
        private static final String NULL = "null";
        private @MonotonicNonNull String name = null;
        private @Nullable String superName = "null";

        private MutableProcessingContext() {
        }

        @Override
        public ClassInfoProvider classInfoProvider() {
            return AbstractRewriteRuleVisitorFactory.this.classInfoProvider;
        }

        @Override
        public String processingClassName() {
            if (this.name == null) {
                throw new IllegalStateException("processingClassName is only available after the class header is visited.");
            }
            return this.name;
        }

        @Override
        public @Nullable String processingClassSuperClassName() {
            if (this.superName == NULL) {
                throw new IllegalStateException("processingClassSuperClassName is only available after the class header is visited.");
            }
            return this.superName;
        }
    }

    private static final class ContextFillerVisitor
    extends ClassVisitor {
        private final MutableProcessingContext context;

        private ContextFillerVisitor(int api, ClassVisitor classVisitor, MutableProcessingContext context) {
            super(api, classVisitor);
            this.context = context;
        }

        public void visit(int version, int access, String name, @Nullable String signature, @Nullable String superName, String @Nullable [] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.context.name = name;
            this.context.superName = superName;
        }
    }
}

